/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.sysutils;

import filenet.vw.base.logging.Logger;
import filenet.vw.sysutils.OperatingSystem;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;

public class VWJavaLauncher {
    private static final String javaVersion = System.getProperty("java.version");
    private static final String defaultJREBin = System.getProperty("java.home") + File.separator + "bin" + File.separator;
    private static final String[] hpFlags = new String[]{"-pa11"};
    private static Logger m_logger = Logger.getLogger("filenet.vw.sysutils");
    private static String m_className = VWJavaLauncher.class.getName();

    public static String GetCmdLine(String jreBin, String[] javaArgs, String command, boolean useJavaw, String noWinExecPath) {
        String jreBinDir;
        String theClassPath = System.getProperty("java.class.path");
        StringBuffer execLine = null;
        String string = jreBinDir = jreBin != null ? jreBin : defaultJREBin;
        if (!jreBinDir.endsWith(File.separator)) {
            jreBinDir = jreBinDir + File.separator;
        }
        if (OperatingSystem.isWindows()) {
            if (useJavaw) {
                execLine = new StringBuffer("\"" + jreBinDir + "javaw\"");
            } else {
                execLine = new StringBuffer("\"" + jreBinDir + "java\"");
                if (noWinExecPath != null) {
                    execLine.insert(0, " ");
                    execLine.insert(0, noWinExecPath);
                }
            }
        } else {
            execLine = new StringBuffer(jreBinDir + "java");
        }
        if (javaArgs != null) {
            for (int i = 0; i < javaArgs.length; ++i) {
                String arg = javaArgs[i];
                if (arg.startsWith("-cp") || arg.startsWith("-classpath")) {
                    theClassPath = javaArgs[i + 1];
                    ++i;
                    continue;
                }
                boolean containsSpace = arg.indexOf(" ") != -1;
                execLine.append(" ");
                if (containsSpace && !arg.startsWith("\"")) {
                    execLine.append("\"");
                }
                execLine.append(arg);
                if (!containsSpace || arg.endsWith("\"")) continue;
                execLine.append("\"");
            }
        }
        StringTokenizer classPathTokens = new StringTokenizer(theClassPath, File.pathSeparator, false);
        StringBuffer buffer = new StringBuffer();
        while (classPathTokens.hasMoreTokens()) {
            buffer.append(classPathTokens.nextToken().trim());
            if (!classPathTokens.hasMoreTokens()) continue;
            buffer.append(File.pathSeparator);
        }
        theClassPath = buffer.toString();
        if (OperatingSystem.isWindows()) {
            if (javaVersion.compareTo("1.3.1") >= 0) {
                execLine.append(" ");
                execLine.append("-Xrs");
            }
            theClassPath = "\"" + theClassPath + "\"";
        } else {
            String ibmBootClassPath = System.getProperty("ibm.jvm.bootclasspath");
            if (ibmBootClassPath != null) {
                execLine.append(" -Dibm.jvm.bootclasspath=" + ibmBootClassPath);
            }
        }
        execLine.append(" -cp ");
        execLine.append(theClassPath);
        execLine.append(" ");
        execLine.append(command);
        if (!OperatingSystem.isWindows()) {
            execLine.insert(0, "nohup ");
        }
        return execLine.toString();
    }

    public static Process exec(String jreBin, String[] javaArgs, String command, boolean useJavaw, String noWinExecPath) throws IOException {
        String method = "exec";
        String cmdLine = VWJavaLauncher.GetCmdLine(jreBin, javaArgs, command, useJavaw, noWinExecPath);
        m_logger.fine(m_className, method, "Executable line: " + cmdLine);
        m_logger.fine(m_className, method, "Forking java process...");
        Process regProcess = Runtime.getRuntime().exec(cmdLine);
        m_logger.fine(m_className, method, "Process started returning result.");
        return regProcess;
    }

    public static Process exec(String[] javaArgs, String command, boolean useJavaw, String noWinExecPath) throws IOException {
        return VWJavaLauncher.exec(null, javaArgs, command, useJavaw, noWinExecPath);
    }
}

